
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  PLL1708.c: functions to communicate with and configure the PLL1708 clock generator IC via SPI
  Written by Nicholas Vinen, 2012-2013
*/

#include "PLL1708.h"
#include "Control_SPI.h"
#include "p33Fxxxx.h"
#include "DCI.h"

unsigned long PLL1708_valid_frequencies[PLL1708_NUM_VALID_FREQUENCIES] = { 16000UL, 22050UL, 24000UL, 32000UL, 44100UL, 48000UL, 64000UL, 88200UL, 96000UL };

void PLL1708_Send_Command(unsigned short cmd) {
  LATDbits.LATD0 = 0;
  SPI_Transfer_Word(cmd);
  LATDbits.LATD0 = 1;
}

static unsigned long PLL1708_current_rate;
bool PLL1708_Configure(unsigned long freq) {
  switch(freq) {
  case 0UL:
    PLL1708_Send_Command(0x7000);
    PLL1708_current_rate = freq;
    break;
  case 32000UL:
    PLL1708_Send_Command(0x7022);
    PLL1708_current_rate = freq;
    break;
  case 44100UL:
    PLL1708_Send_Command(0x7021);
    PLL1708_current_rate = freq;
    break;
  case 48000UL:
    PLL1708_Send_Command(0x7020);
    PLL1708_current_rate = freq;
    break;
  case 64000UL:
    PLL1708_Send_Command(0x7026);
    PLL1708_current_rate = freq;
    break;
  case 88200UL:
    PLL1708_Send_Command(0x7025);
    PLL1708_current_rate = freq;
    break;
  case 96000UL:
    PLL1708_Send_Command(0x7024);
    PLL1708_current_rate = freq;
    break;
  case 16000UL:
    PLL1708_Send_Command(0x702A);
    PLL1708_current_rate = freq;
    break;
  case 22050UL:
    PLL1708_Send_Command(0x7029);
    PLL1708_current_rate = freq;
    break;
  case 24000UL:
    PLL1708_Send_Command(0x7028);
    PLL1708_current_rate = freq;
    break;
  default:
    return false;
  }
  DCI_Sampling_Rate_Changed(freq);
  return true;
}

unsigned long PLL1708_Get_Current_Rate() {
  return PLL1708_current_rate;
}

